unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MPlayer, StdCtrls, ExtCtrls, ImgList, ComCtrls;

type
  TForm1 = class(TForm)
    MediaPlayer1: TMediaPlayer;
    btnFelvetel: TButton;
    btnMentes: TButton;
    btnStop: TButton;
    btnLejatszas: TButton;
    SaveDialog1: TSaveDialog;
    Image1: TImage;
    ImageList1: TImageList;
    Timer1: TTimer;
    StatusBar1: TStatusBar;
    procedure FormCreate(Sender: TObject);
    procedure btnFelvetelClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnMentesClick(Sender: TObject);
    procedure btnLejatszasClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}
var
  alapWAVFajl:string;

procedure TForm1.FormCreate(Sender: TObject);
begin
  alapWAVFajl:=GetCurrentDir+'\_tmp.wav';
  SaveDialog1.InitialDir:=GetCurrentDir+'\wav';
  // nyomgombok (nem-) engedlyezse:
  btnFelvetel.Enabled:=true;
  btnStop.Enabled:=false;
  btnMentes.Enabled:=false;
  btnLejatszas.Enabled:=false;
end;

procedure TForm1.btnFelvetelClick(Sender: TObject);
var hibaStr:string;
begin
 with MediaPlayer1 do
 begin
  if DeviceID<>0 then  // ha van megnyitott mdiaeszkz
   begin
     Stop; // lejtszs lelltsa
     Close;
   end;

   DeviceType := dtWaveAudio;
   FileName := alapWAVFajl;
   try
     Open;   // a csatorna megnyitsa
     // az j hanganyag bekeldsi pontja:
     StartPos:=1;   // 1 ezredmsodperc az alapfjl elejtl
     StartRecording;         // hangfelvtel
     // nyomgombok (nem-) engedlyezse:
     btnStop.Enabled:=true;
     btnFelvetel.Enabled:=false;
     btnMentes.Enabled:=false;
     btnLejatszas.Enabled:=false;
     Timer1.Enabled:=true;         // idzt bekapcsolsa
   except
     hibaStr := 'Hibakd: ' + IntToStr(Error) + #13#10;
     MessageDlg(hibaStr + ErrorMessage, mtError, [mbOk], 0);
   end;
 end;
end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
   MediaPlayer1.Stop;  // mdialejtsz lelltsa
   Timer1.Enabled:=false;    // az idzt kikapcsolsa
   Image1.Picture.Bitmap:=nil;  // az animlt kp "eltntetse"
   // nyomgombok (nem-) engedlyezse:
   btnStop.Enabled:=false;
   btnFelvetel.Enabled:=true;
   btnMentes.Enabled:=true;
   btnLejatszas.Enabled:=true;
   StatusBar1.SimpleText:=''; // az llapotsor feliratnak trlse
end;

procedure TForm1.btnMentesClick(Sender: TObject);
var s, ujfajl, hibaStr:string;
begin
  if SaveDialog1.Execute then
   begin
    ujfajl:= SaveDialog1.FileName;

    if (ujfajl <> alapWAVFajl) then
     begin
      StatusBar1.SimpleText:='Felvtel mentse...';
      s:=AnsiUpperCase(ExtractFileExt(SaveDialog1.FileName));
      if (s <> '.WAV') then ujfajl:=SaveDialog1.FileName+'.wav';

      with MediaPlayer1 do
       begin
        DeviceType := dtWaveAudio;
        FileName := ujfajl;
        try
          Save;   // a csatorna megnyitsa
          StatusBar1.SimpleText:='Felvtel mentse O.K.';
        except
          hibaStr := 'Hibakd: ' + IntToStr(Error) + #13#10;
          MessageDlg(hibaStr + ErrorMessage, mtError, [mbOk], 0);
          StatusBar1.SimpleText:='Felvtel mentse nem sikerlt';
        end;
       end;
     end
    else begin
          MessageBeep(0);
          StatusBar1.SimpleText:='Vlasszon ms fjlnevet!';
         end;
   end;
end;

procedure TForm1.btnLejatszasClick(Sender: TObject);
begin
   MediaPlayer1.Rewind;   // mdialejtsz visszatekerse
   MediaPlayer1.Play;       // lejtszs elindtsa
   btnStop.Enabled:=true;      // a Stop gomb engedlyezse
   // az llapotjelz sor feliratozsa:
   if MediaPlayer1.FileName = alapWAVFajl
   // ha mg nem mentettk el az j felvtelt egy fjlba:
    then StatusBar1.SimpleText:='j felvtel lejtszsa'
    // ha mr elmentettk az j felvtelt egy WAV fjlba:
    else StatusBar1.SimpleText:=MediaPlayer1.FileName+' lejtszsa';
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 with MediaPlayer1 do
  if DeviceID<>0 then  // ha van megnyitott mdiaeszkz
   begin
     Stop; // lejtszs lelltsa
     Close; // mdialejtsz lezrsa
   end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
const
  melyik:integer=0;
  eltelt:Cardinal=0;
begin
  // kpvlts (animci):
  ImageList1.GetBitmap(melyik, Image1.Picture.Bitmap);
  Image1.Repaint;
  melyik:=(melyik+1) mod ImageList1.Count;
  // llapotsor feliratnak frisstse:
  eltelt:=eltelt+Timer1.Interval;
  StatusBar1.SimpleText:='Felvtel: '+IntToStr(eltelt div 1000)+' mp';
end;

end.
